﻿const { SerialPort } = require("serialport");
const net = require("net");
const pewModule = require('./pew_module');
const pew = new pewModule.pewModule();
var serverSocket = [];
var socketTemp;
var usePort, maxClients, connectionTimeout, listenIP;
var usedServerSocketRemotePort;
const moduleName = "COM2 (RS485) transparent mode";
const serviceID = 3;

//Catch exceptions
process.on('uncaughtException', function (err) {
    pew.sysLogMessage(moduleName, "Uncaught exception: " + err.stack);
})

//Read Configurations
var interfaceConfig = pew.getConfFileSync(pew.Constants.requests.READ_INTERFACE);
var portConfig = pew.getConfFileSync(pew.Constants.requests.READ_PORTS);

//If any configuration could not be loaded -> log the message and stop execution
if (interfaceConfig.err) {
    pew.sysLogMessage(moduleName, interfaceConfig.err_msg);
    return;
}

if (portConfig.err) {
    pew.sysLogMessage(moduleName, portConfig.err_msg);
    return;
}

let com = interfaceConfig.data.interface.filter(el => el.id === "/RS485/RS232");
let tcpConnection = portConfig.data.thread.filter(el => el.service === serviceID);

if (!com[0].enabled) {
    return pew.sysLogMessage(moduleName, pew.Constants.COM_NOT_ENABLED);
}

if (tcpConnection.length <= 0 || tcpConnection[0].port <= 0) {
    return pew.sysLogMessage(moduleName, pew.Constants.TCP_PORT_DISABLED);
}

usePort = tcpConnection[0].port;
maxClients = tcpConnection[0].clients;
connectionTimeout = tcpConnection[0].timeout * 1000;
ipStart = tcpConnection[0].ip_start;
ipEnd = tcpConnection[0].ip_end;
listenIP = pew.Constants.ALL_IP;

if (ipStart === pew.Constants.LOCAL_HOST || ipEnd === pew.Constants.LOCAL_HOST) {
    listenIP = pew.Constants.LOCAL_HOST;
}

// Create a port
const port = new SerialPort({
    path: "/dev/com2",
    baudRate: com[0].baudrate,
    dataBits: com[0].bits,
    parity: com[0].parity.toLowerCase(),
    stopBits: com[0].stopbits,
    flowControl: false,
});

//Create tcp server
var server = net.createServer(function (socket) {
    socketTemp = socket;
    //Check if remote IP is allowed
    let isIPAllowed = false;
    if (ipStart === pew.Constants.ALLOW_ALL_IPS || ipEnd === pew.Constants.ALLOW_ALL_IPS) {
        isIPAllowed = true;
    }
    else {
        isIPAllowed = pew.isIPWithinRange(pew.ip2int(ipStart), pew.ip2int(ipEnd), pew.ip2int(socketTemp.remoteAddress));
    }

    if (
        serverSocket.length < maxClients &&
        serverSocket.filter((el) => el.remotePort === socketTemp.remotePort)
            .length === 0 && isIPAllowed
    ) {
        serverSocket.push(socket);
        serverSocket[serverSocket.length - 1].setTimeout(connectionTimeout, function () {
            pew.sysLogMessage(moduleName, "connection server closed due to timeout");
            let i = serverSocket.findIndex((el) => {
                return el.remotePort === this.remotePort;
            });
            if (i !== -1) {
                serverSocket[i].destroy();
            }
            serverSocket = serverSocket.filter((el, index) => index !== i);
        });
        serverSocket[serverSocket.length - 1]
            .on("data", function (data) {
                usedServerSocketRemotePort = this.remotePort;
                port.write(data, function (err) {
                    if (err) {
                        return pew.sysLogMessage(moduleName, "Error on write: " + err.message);
                    }
                });
            })
            .on("end", function () {
                serverSocket = serverSocket.filter(
                    (el) => el.remotePort !== this.remotePort
                );
            })
            .on("error", (err) => {
                pew.sysLogMessage(moduleName, "Server err " + err);
            });
    }
    else {
        if (!isIPAllowed) {
            pew.sysLogMessage(moduleName, "Incoming IP address has been denied.");
        }

        if (serverSocket.length === maxClients) {
            pew.sysLogMessage(module, "Max number of clients reached.");
        }
        socket.destroy();
    }
});

server.listen(usePort, listenIP);

// Open errors will be emitted as an error event
port.on("error", function (err) {
    pew.sysLogMessage(moduleName, err.message);
});

// Switches the port into "flowing mode"
port.on("data", function (data) {
    let index = serverSocket.findIndex(
        (el) => el.remotePort === usedServerSocketRemotePort
    );
    serverSocket[index].write(data);
});
